//===============================================================================================
// Provides a variety of common DHTML related methods
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

function getWindowHeight()
	// Returns the client area height of the current window
{
	var h=window.document.documentElement.clientHeight; // IE 6 and higher (strict mode)
	if(h<1) h=window.document.body.offsetHeight; // IE 5.5 and lower

	return h;
}

//------------------------------------------------------------------------------------------------
function getWindowWidth()
	// Returns the client area width of the current window
{
	var w=window.document.documentElement.clientWidth; // IE 6 and higher (strict mode)
	if(w<1) w=window.document.body.offsetWidth; // IE 5.5 and lower

	return w;
}

//----------------------------------------------------------------------------
function show(e) { if(e) e.style.visibility="visible"; }
	// Makes the specified element visible

//----------------------------------------------------------------------------
function showById(id)
	// Makes the element identified by id visible
{
	var e=document.getElementById(id);
	if(e) e.style.visibility="visible";
}

//----------------------------------------------------------------------------
function hide(e){ if(e) e.style.visibility="hidden"; }
	// Hides the specified element...still takes up space on the page

//----------------------------------------------------------------------------
function hideById(id)
	// Hides the element identified by id...still takes up space on the page
{
	var e=document.getElementById(id);	
	if(e) e.style.visibility="hidden";
}

//------------------------------------------------------------------------------------------------
function toClickableImg( src, hoverSrc, act, title )
{
	var s = '<img border="0" src="' + src + '"';
	if( title ) s += ' alt="' + title + '"';
	if( act ) s += ' onclick="' + act + '"';
	if( hoverSrc )
	{
		s += ' onmouseover="this.src=\'' + hoverSrc + '\'"';
		s += ' onmouseout="this.src=\'' + src + '\'"';
		s += ' style="cursor:hand"';
	}
	s += '>';

	return s;
}

//------------------------------------------------------------------------------------------------
function renderClickableImg( src, hoverSrc, act, title )
{	
	document.write( toClickableImg(src,hoverSrc,act,title) );
}

//----------------------------------------------------------------------------
function toSpacer( w, h )
	// Appends a spacer of the specified width and height
{
	if(!h) h = 1;
	if(!w) w = 1;
	
	return '<img src="../img/clear.gif" width="'+w+'" height="'+h+'" border="0">';
}

//----------------------------------------------------------------------------
function appendSpacer( w, h ) { document.write( toSpacer(w,h) ); }
	// Appends a spacer of the specified width and height

